/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.sdgraph;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import cz.insophy.inplan.sdgraph.AbstractSdgEdge;
import cz.insophy.inplan.sdgraph.MttEdge;
import cz.insophy.inplan.sdgraph.SdgEdge;
import cz.insophy.inplan.sdgraph.SdgNode;
import cz.insophy.inplan.sdgraph.StoreDependencyGraph;
import cz.insophy.inplan.sdgraph.StoreDependencyGraphImpl;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.util.Collections3;
import cz.insophy.inplan.util.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MttComputer {
    private static final Logger LOG = LoggerFactory.getLogger(MttComputer.class);
    private static final Comparator<Map.Entry<Material, Collection<EdgeWrapper>>> MATERIAL_ID_COMPARATOR = new Comparator<Map.Entry<Material, Collection<EdgeWrapper>>>(){

        @Override
        public int compare(Map.Entry<Material, Collection<EdgeWrapper>> o1, Map.Entry<Material, Collection<EdgeWrapper>> o2) {
            Material m1 = o1.getKey();
            Material m22 = o2.getKey();
            if (m1 == StoreDependencyGraph.INTER_GAR_MATERIAL && m22 != StoreDependencyGraph.INTER_GAR_MATERIAL) {
                return -1;
            }
            if (m1 != StoreDependencyGraph.INTER_GAR_MATERIAL && m22 == StoreDependencyGraph.INTER_GAR_MATERIAL) {
                return 1;
            }
            if (m1 == m22) {
                return 0;
            }
            return m1.getId().compareTo(m22.getId());
        }
    };
    private StoreDependencyGraphImpl sdg;
    private int tracingDepth;
    private final Table<SdgNode, SdgNode, Map<List<MttEdge>, Double>> mtts;
    private final Map<EdgeWrapper, Double> edgeTotalFilling;
    private final Table<SdgEdge, Material, EdgeWrapper> outgoingMaterialsIncomingEdgeWrappers;

    MttComputer(StoreDependencyGraphImpl sdg) {
        this.mtts = HashBasedTable.create(sdg.getAllNodes().size(), 1);
        this.edgeTotalFilling = Maps.newHashMap();
        this.outgoingMaterialsIncomingEdgeWrappers = HashBasedTable.create(sdg.getAllEdges().size(), 2);
        this.sdg = sdg;
    }

    Table<SdgNode, SdgNode, Map<List<MttEdge>, Double>> computeMtt() {
        LOG.info("Computing MTT...");
        this.prepareWrappers();
        ArrayList<AbstractSdgEdge> leafEdges = Lists.newArrayList();
        Collection<SdgNode> leafNodes = Collections2.filter(this.sdg.getAllNodes(), SdgNode::isLeaf);
        for (SdgNode node : leafNodes) {
            for (SdgEdge edge : node.getIncomingEdges()) {
                leafEdges.add((AbstractSdgEdge)edge);
            }
        }
        leafEdges.sort(Comparator.comparingInt(AbstractSdgEdge::getOrderKey));
        for (AbstractSdgEdge edge : leafEdges) {
            this.tracingDepth = 0;
            this.traceEdge(new EdgeWrapper(edge, edge.getQty()), edge.getQty(), Lists.newArrayList());
        }
        LOG.info("Computing MTT done.");
        return this.mtts;
    }

    private void prepareWrappers() {
        for (SdgNode node : this.sdg.getAllNodes()) {
            Set materials = node.getOutgoingEdges().stream().map(SdgEdge::getMaterial).collect(Collectors.toSet());
            for (Material material : materials) {
                for (SdgEdge incomingEdge : node.getIncomingEdges()) {
                    EdgeWrapper ew = new EdgeWrapper((AbstractSdgEdge)incomingEdge, incomingEdge.getQty() / (double)materials.size());
                    this.outgoingMaterialsIncomingEdgeWrappers.put(incomingEdge, material, ew);
                }
            }
        }
    }

    private double traceEdge(EdgeWrapper edgeWrapper, double tracedQty, List<Tuple<Material, SdgNode>> materialNodeChain) {
        double remainingTracedQty;
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}Tracing edge {}...", (Object)"  ".repeat(this.tracingDepth), (Object)edgeWrapper);
        }
        ++this.tracingDepth;
        SdgNode srcNode = edgeWrapper.edge.getSourceNode();
        SdgNode dstNode = edgeWrapper.edge.getDestinationNode();
        Material edgeMaterial = edgeWrapper.edge.getMaterial();
        double qty = edgeWrapper.qty;
        Double sentQtyTotal = this.edgeTotalFilling.computeIfAbsent(edgeWrapper, k -> 0.0);
        if ((qty -= sentQtyTotal.doubleValue()) < 1.0E-7) {
            return tracedQty;
        }
        materialNodeChain.add(Tuple.create(edgeMaterial, dstNode));
        if (tracedQty - qty > 1.0E-7) {
            remainingTracedQty = tracedQty - qty;
            tracedQty = qty;
            this.putQties(srcNode, qty, materialNodeChain);
            this.edgeTotalFilling.put(edgeWrapper, edgeWrapper.qty);
        } else {
            remainingTracedQty = 0.0;
            this.putQties(srcNode, tracedQty, materialNodeChain);
            this.edgeTotalFilling.put(edgeWrapper, sentQtyTotal + tracedQty);
        }
        Map<Material, Collection<EdgeWrapper>> edgesByMat = this.getIncomingEdges(srcNode, edgeMaterial);
        for (Map.Entry<Material, Collection<EdgeWrapper>> entry : Collections3.sorted(edgesByMat.entrySet(), MATERIAL_ID_COMPARATOR)) {
            EdgeWrapper incomingEdgeWrapper;
            Collection<EdgeWrapper> edgeWrappers = entry.getValue();
            double srcOutputQty = srcNode.getTotalOutgoingQty(edgeMaterial);
            double srcInputQty = 0.0;
            for (EdgeWrapper incomingEdgeWrapper2 : edgeWrappers) {
                srcInputQty += incomingEdgeWrapper2.qty;
            }
            double reverseTfRatio = MttComputer.getReverseTfRatio(srcInputQty, srcOutputQty);
            double matTracedQty = tracedQty * reverseTfRatio;
            Iterator<EdgeWrapper> iterator = edgeWrappers.iterator();
            while (iterator.hasNext() && !((matTracedQty = this.traceEdge(incomingEdgeWrapper = iterator.next(), matTracedQty, materialNodeChain)) < 1.0E-7)) {
            }
        }
        materialNodeChain.remove(materialNodeChain.size() - 1);
        --this.tracingDepth;
        return remainingTracedQty;
    }

    private Map<Material, Collection<EdgeWrapper>> getIncomingEdges(SdgNode srcNode, Material outgoingMaterial) {
        ArrayListMultimap<Material, EdgeWrapper> ews = ArrayListMultimap.create();
        for (SdgEdge edge : srcNode.getIncomingEdges()) {
            EdgeWrapper wrapper = this.outgoingMaterialsIncomingEdgeWrappers.get(edge, outgoingMaterial);
            if (wrapper == null) {
                wrapper = new EdgeWrapper((AbstractSdgEdge)edge, edge.getQty());
                this.outgoingMaterialsIncomingEdgeWrappers.put(edge, outgoingMaterial, wrapper);
            }
            ews.put(edge.getMaterial(), wrapper);
        }
        return ews.asMap();
    }

    private void putQties(SdgNode srcNode, double qty, List<Tuple<Material, SdgNode>> materialNodeChain) {
        SdgNode neighbourSource = srcNode;
        ArrayList<MttEdge> subchain = Lists.newArrayListWithCapacity(materialNodeChain.size());
        int n = materialNodeChain.size();
        for (int i = n - 1; i >= 0; --i) {
            Double sentQty;
            Material material = materialNodeChain.get(i).getFirst();
            SdgNode target = materialNodeChain.get(i).getSecond();
            subchain.add(new MttEdge(neighbourSource, target, material));
            neighbourSource = target;
            Map<List<MttEdge>, Double> sentQties = this.mtts.get(srcNode, target);
            if (sentQties == null) {
                sentQties = Maps.newHashMap();
                this.mtts.put(srcNode, target, sentQties);
            }
            if ((sentQty = sentQties.get(subchain)) == null) {
                sentQty = 0.0;
            }
            sentQties.put(ImmutableList.copyOf(subchain), sentQty + qty);
        }
    }

    private static double getReverseTfRatio(double inputQty, double outputQty) {
        return inputQty / outputQty;
    }

    private static class EdgeWrapper {
        private AbstractSdgEdge edge;
        private double qty;

        private EdgeWrapper(AbstractSdgEdge edge, double qty) {
            this.edge = edge;
            this.qty = qty;
        }
    }
}

